<?php

namespace Database\Seeders;
 
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;
use App\Models\Settings;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // \App\Models\User::factory(10)->create();
        $route_names = [
            [
                'title' => 'Member Page',
                'routes' => [
                    'member.index',
                    'member.create',
                    'member.store',
                    'member.edit',
                    'member.update',
                    'member.destroy',
                ],
            ],
            [
                'title' => 'Membership Type Page',
                'routes' => [
                    'plan.index',
                    'plan.create',
                    'plan.store',
                    'plan.edit',
                    'plan.update',
                    'plan.destroy',
                ],
            ],
            [
                'title' => 'Membership Page',
                'routes' => [
                    'membership.index',
                    'membership.create',
                    'membership.store',
                ],
            ],
            [
                'title' => 'Attendance Page',
                'routes' => [
                    'attendance.index',
                    'attendance.create',
                    'attendance.store',
                    'attendance.update',
                    'attendance.manual',
                    'attendance.store_manual',
                ],
            ],
            [
                'title' => 'Payment Page',
                'routes' => [
                    'transaction.index',
                    'transaction.create',
                    'transaction.store',
                    'transaction.edit',
                    'transaction.update',
                ],
            ],
            [
                'title' => 'Settings Page',
                'routes' => [
                    'settings.index',
                    'settings.store',
                    'settings.update_logo',
                    'settings.remove_logo'
                ],
            ],
            [
                'title' => 'Reports Page',
                'routes' => [
                    'reports.member_information',
                    'reports.payment_transactions',
                    'reports.attendance',
                ],
            ],
            [
                'title' => 'Expense Page',
                'routes' => [
                    'income.index',
                    'income.create',
                    'income.store',
                    'income.edit',
                    'income.update',
                    'income.destroy',
                ],
            ],
            [
                'title' => 'Income Page',
                'routes' => [
                    'expense.index',
                    'expense.create',
                    'expense.store',
                    'expense.edit',
                    'expense.update',
                    'expense.destroy',
                ],
            ],
            [
                'title' => 'User Role Page',
                'routes' => [
                    'user_role.index',
                    'user_role.create',
                    'user_role.store',
                    'user_role.edit',
                    'user_role.update',
                    'user_role.destroy',
                ],
            ],
            [
                'title' => 'User Page',
                'routes' => [
                    'user.index',
                    'user.create',
                    'user.store',
                    'user.edit',
                    'user.update',
                    'user.destroy',
                ],
            ],
        ];

        foreach ($route_names as $route_name) {
            foreach ($route_name['routes'] as $route) {
                Permission::updateOrCreate(['name' => $route]);
            }
        }

        // Register or update an admin
        $admin = User::updateOrCreate(
            ['email' => 'admin@gmail.com'], // Match email to check if record exists
            [
                'name' => 'Super Admin',
                'status' => 'active',
                'password' => Hash::make('123456789') // Update these fields if record exists
            ]
        );

        // Register or update settings
        $settings = [
            'brand_name' => 'Casual Fitness',
            'phone' => '923132140179',
            'email' => 'info@casualfitness.com',
            'currency' => 'USD',
            'country' => 'Pakistan',
            'address' => 'Karachi, Gulistan-e-Johar',
            'language' => 'en',
            'logo' => 'default_logo.png',
            'login_image' => 'default_login_image.jpg',
            'favicon' => 'default_favicon.ico',
            'date_format' => 'd-m-Y',
            'timezone' => 'Asia/Tokyo',
        ];

        foreach ($settings as $name => $value) {
            Settings::updateOrCreate(['name' => $name], ['value' => $value]);
        }

        // Register or update roles
        $role = Role::updateOrCreate(['name' => 'Super Admin']);
        $admin->assignRole('Super Admin');
    }
}